<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CutiApproval extends Model
{
    use HasFactory;

    protected $fillable = [
        'cuti_id',
        'step',
        'approved_by',
        'status',
        'catatan',
        'approved_at'
    ];

    protected $casts = [
        'approved_at' => 'datetime'
    ];

    /**
     * Relasi ke Cuti
     */
    public function cuti()
    {
        return $this->belongsTo(Cuti::class);
    }

    /**
     * Relasi ke User yang approve
     */
    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    /**
     * Get role label - INI YANG PENTING!
     */
    public function getRoleLabelAttribute()
    {
        $labels = [
            'manager' => 'Manager',
            'gm' => 'GM',
            'hrd' => 'HRD'
        ];

        return $labels[$this->step] ?? strtoupper($this->step);
    }

    /**
     * Get step name (alias untuk compatibility)
     */
    public function getStepNameAttribute()
    {
        return $this->role_label;
    }
}
